### sesson 3: classical linear models

white.lmq2 <- aov(Gas ~ Insul/poly(Temp, 2), whiteside)
white.lml2 <- aov(Gas ~ Insul/Temp, whiteside)
white.lml <- aov(Gas ~ Insul + Temp, whiteside)
white.lml0 <- aov(Gas ~ Temp, whiteside)
white.lm0 <- aov(Gas ~ 1, whiteside)
anova(white.lm0, white.lml0, white.lml, white.lml2, white.lmq2)

contr.helmert(4)
fractions(ginv(contr.helmert(4)))

M <- diag(4)[1:3, ]
M[col(M) - row(M) == 1] <- -1
M
M0 <- fractions(ginv(M))

# 6.8  An unbalanced four-way layout

require(MASS)
with(quine, table(Lrn, Age, Sex, Eth))

Means <- with(quine, tapply(Days, list(Eth, Sex, Age, Lrn), mean))
Vars  <- with(quine, tapply(Days, list(Eth, Sex, Age, Lrn), var))
SD <- sqrt(Vars)
par(mfrow = c(1, 2), pty="s")
plot(Means, Vars, xlab = "Cell Means", ylab = "Cell Variances")
plot(Means, SD, xlab = "Cell Means", ylab = "Cell Std Devn.")

par(mfrow=c(1,2))
boxcox(Days+1 ~ Eth*Sex*Age*Lrn, data = quine, singular.ok = T,
  lambda = seq(-0.05, 0.45, len = 20))

logtrans(Days ~ Age*Sex*Eth*Lrn, data = quine, xlab=expression(alpha),
    alpha = seq(0.75, 6.5, len = 20), singular.ok = T)

quine.hi <- aov(log(Days + 2.5) ~ Age*Sex*Eth*Lrn, quine)
quine.nxt <- update(quine.hi, . ~ . - Eth:Sex:Age:Lrn)
dropterm(quine.nxt, test = "F")

quine.lo <- aov(log(Days+2.5) ~ 1, quine)
addterm(quine.lo, quine.hi, test = "F")

quine.stp <- stepAIC(quine.nxt,
   scope = list(upper = ~Eth*Sex*Age*Lrn, lower = ~1),
   trace = FALSE)
summary(quine.stp)

dropterm(quine.stp, test = "F")
quine.3 <- update(quine.stp, . ~ . - Eth:Age:Lrn)
dropterm(quine.3, test = "F")

quine.4 <- update(quine.3, . ~ . - Eth:Age)
dropterm(quine.4, test = "F")

quine.5 <- update(quine.4, . ~ . - Age:Lrn)
dropterm(quine.5, test = "F")

quine.bic <- stepAIC(quine.nxt, k = log(nrow(quine)),
   scope = list(upper = ~Eth*Sex*Age*Lrn, lower = ~1),
   trace = F)
dropterm(quine.bic, test = "F")


